<?php
namespace Trs\Tests\Unit\Common;

use Dgm\NumberUnit\NumberUnit;
use PHPUnit_Framework_TestCase;


class NumberUnitTest extends PHPUnit_Framework_TestCase
{
	public function testChunks()
	{
		$unit = new NumberUnit(1000);
		$this->assertSame(0, $unit->chunks(0, 1));
		$this->assertSame(1, $unit->chunks(0.1, 1));
		$this->assertSame(1, $unit->chunks(0.01, 1));
		$this->assertSame(1, $unit->chunks(0.001, 1));
		$this->assertSame(5, $unit->chunks(10.001, 2.5));
	}

	public function testChunksIsNormalizingValue()
	{
		$unit = new NumberUnit(1000);
		$this->assertSame(0, $unit->chunks(0.0001, 1));
	}

	public function testChunksIsNormalizingChunkSize()
	{
		$unit = new NumberUnit(1000);
		$this->assertSame(1, $unit->chunks(1, 0.9999));
	}

	public function testChunksWithZeroChunkSize()
	{
		$unit = new NumberUnit(1000);
		$this->expectException(\InvalidArgumentException::class);
		$unit->chunks(1, 0);
	}
}
