<?php
namespace Trs\Migration;

use Trs\Migration\Interfaces\IPerRuleMigration;


class Migration_1_16_7 implements IPerRuleMigration
{
    public function migrateRule(array &$rule)
    {
        self::updatePostcodeRangeSeparator($rule);
    }

    static public function updatePostcodeRangeSeparator(array &$rule)
    {
        foreach ($rule['conditions']['list'] as &$condition) {
            if (@$condition['condition'] === 'destination' && !empty($condition['value']) && is_array($condition['value'])) {
                foreach ($condition['value'] as &$destination) {
                    @list($location, $postcodes) = explode("/zip:", $destination);
                    if (isset($postcodes)) {
                        $destination = $location . "/zip:" . str_replace("-", "...", $postcodes);
                    }
                }
            }
        }
    }
}

return new Migration_1_16_7();