<?php
namespace Trs\Migration\Storage;


interface IStorage
{
    /**
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    function get($key, $default = false);

    /**
     * @param string $key
     * @param mixed $value
     */
    function set($key, $value, $autoload = null);

    /**
     * @param string $sqlLikePatterns  A pattern formed for SQL LIKE operator. Don't forget to escape special
     *                                 chars such as '%', '\' and '_' with {@see IStorageDriver::escapeForLike()}.
     * @return string[]|iterable  A list of keys matching the pattern.
     */
    function findKeysLike($sqlLikePatterns);

    /**
     * @param string $string
     * @return string
     */
    function escapeForLikePattern($string);
}