<?php
namespace Dgm\Comparator\Tests;

use Dgm\Comparator\NumberComparator;
use InvalidArgumentException;
use PHPUnit_Framework_TestCase;


class NumberComparatorTest extends PHPUnit_Framework_TestCase
{
    /** @dataProvider compareTests */
    public function testCompare($a, $b, $precision, $operator)
    {
        $comparator = new NumberComparator($precision);
        $this->assertTrue($comparator->compare($a, $b, $operator));
    }

    public function testFailsOnNonNumericValues()
    {
        $comparator = new NumberComparator(1);
        $this->expectException(InvalidArgumentException::class);
        $comparator->compare('a', 'b');
    }

    static public function compareTests()
    {
        return array(

            array(0, 0, 100000, '='),
            array(1.1, 1.2, 1, '='),
            array(1.1, 1.2, 5, '='),
            array(1.1, 1.2, 10, '<'),
            array(-1, -1.001, 1000, '>'),
            array(-5, +5, 0.1, '<'),
            array(-5, +5, 0.01, '='),
            array(101, 102, 0.1, '='),
            array(101, 102, 1, '<'),

            array(0.6, 0.1*6, 1e+18, '<'),
            array(0.6, 0.1*6, 1e+3, '='),
            array(1, 0.1*10, 1e+20, '='),
            array(1, 0.1*10, 1e+5, '='),

            array(0.6, 0.1*6, null, '<'),
        );
    }
}